/*
 * Decompiled with CFR 0.152.
 */
package LegendaryCardMaker.CustomCardMaker.structure;

import LegendaryCardMaker.CustomCardMaker.ALIGNMENT;
import LegendaryCardMaker.CustomCardMaker.CustomCardMaker;
import LegendaryCardMaker.CustomCardMaker.structure.CustomElement;
import LegendaryCardMaker.Icon;
import LegendaryCardMaker.WordDefinition;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.List;
import javax.swing.SwingUtilities;

public class ElementTextArea
extends CustomElement {
    public String defaultValue;
    public ALIGNMENT alignmentHorizontal = ALIGNMENT.LEFT;
    public ALIGNMENT alignmentVertical = ALIGNMENT.TOP;
    public boolean allowChange;
    public Color colour;
    public int textSize = 27;
    public int textSizeBold = 27;
    public String fontName;
    public String fontNameBold;
    public int fontStyle;
    public String rectXArray;
    public String rectYArray;
    public boolean debug;
    public double textGapHeight = 0.6;
    public double textDefaultGapHeight = 0.2;
    public int textIconBlurRadius = 5;
    public boolean textIconBlurDouble = true;
    public int expandTextIcon = 0;
    private Polygon polygon = null;
    public String value;

    public String getValue() {
        if (this.value != null) {
            return this.value;
        }
        return this.defaultValue;
    }

    @Override
    public void drawElement(Graphics2D g) {
        if (this.getValue() != null) {
            BufferedImage bi = new BufferedImage(CustomCardMaker.cardWidth, CustomCardMaker.cardHeight, 2);
            Graphics2D g2 = this.getGraphics(bi);
            g2 = this.setGraphicsHints(g2);
            if (this.debug) {
                g2.setColor(Color.LIGHT_GRAY);
                g2.fillPolygon(this.getPolygon());
            }
            g2.setColor(this.colour);
            try {
                Font font = Font.createFont(0, new File("Swiss 721 Light Condensed.ttf"));
                font = font.deriveFont((float)this.textSize);
                if (this.fontName != null) {
                    font = new Font(this.fontName, this.fontStyle, this.textSize);
                }
                g2.setFont(font);
                g2 = this.setGraphicsHints(g2);
                Font fontBold = Font.createFont(0, new File("Swiss 721 Black Condensed.ttf"));
                fontBold = fontBold.deriveFont((float)this.textSizeBold);
                if (this.fontName != null && this.fontNameBold == null) {
                    fontBold = new Font(this.fontName, 1, this.textSizeBold);
                }
                if (this.fontNameBold != null) {
                    fontBold = new Font(this.fontNameBold, 1, this.textSizeBold);
                }
                FontMetrics metrics = g2.getFontMetrics(font);
                int x = -1;
                int y = -1;
                Point startPoint = this.getStartPosition();
                x = startPoint.x;
                y = startPoint.y + metrics.getAscent();
                List<WordDefinition> words = WordDefinition.getWordDefinitionList(this.getValue());
                for (WordDefinition wd : words) {
                    String s = wd.word;
                    String spaceChar = "";
                    if (wd.space) {
                        spaceChar = " ";
                    }
                    if (s.startsWith("<k>")) {
                        g2.setFont(fontBold);
                        metrics = g2.getFontMetrics(fontBold);
                        s = s.replace("<k>", "");
                        g2 = this.setGraphicsHints(g2);
                        continue;
                    }
                    if (s.startsWith("<r>")) {
                        g2.setFont(font);
                        metrics = g2.getFontMetrics(font);
                        s = s.replace("<r>", "");
                        g2 = this.setGraphicsHints(g2);
                        continue;
                    }
                    boolean gap = false;
                    if (s.equals("<g>")) {
                        gap = true;
                    }
                    Icon icon = this.isIcon(s);
                    if (gap) {
                        x = this.getXStart(y += g2.getFontMetrics(font).getHeight() + this.getPercentage(g2.getFontMetrics(font).getHeight(), this.textGapHeight));
                        continue;
                    }
                    if (icon == null) {
                        int stringLength = SwingUtilities.computeStringWidth(metrics, s);
                        if (!this.getPolygon().contains(x + stringLength, y)) {
                            x = this.getXStart(y += g2.getFontMetrics(font).getHeight() + this.getPercentage(g2.getFontMetrics(font).getHeight(), this.textDefaultGapHeight));
                        }
                        g2.drawString(String.valueOf(s) + " ", x, y);
                        x += stringLength + SwingUtilities.computeStringWidth(metrics, spaceChar);
                        continue;
                    }
                    if (icon == null) continue;
                    BufferedImage i = this.getIconMaxHeight(icon, this.getPercentage(metrics.getHeight(), 1.2));
                    if (!this.getPolygon().contains(x + i.getWidth(), y)) {
                        x = this.getXStart(y += g2.getFontMetrics(font).getHeight() + this.getPercentage(g2.getFontMetrics(font).getHeight(), this.textDefaultGapHeight));
                    }
                    int modifiedY = y - i.getHeight() + metrics.getDescent();
                    if (icon.isUnderlayMinimized()) {
                        this.drawUnderlay(i, g2, 2, x, modifiedY, this.textIconBlurRadius, this.textIconBlurDouble, this.expandTextIcon, Color.black);
                    }
                    g2.drawImage((Image)i, x, modifiedY, null);
                    x += i.getWidth() + SwingUtilities.computeStringWidth(metrics, spaceChar);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            g.drawImage((Image)bi, 0, 0, null);
            g2.dispose();
        }
    }

    public Polygon getPolygon() {
        if (this.polygon == null) {
            String[] xsplit = this.rectXArray.split(",");
            int[] xpoints = new int[xsplit.length];
            int i = 0;
            while (i < xsplit.length) {
                xpoints[i] = Integer.parseInt(xsplit[i].trim());
                ++i;
            }
            String[] ysplit = this.rectYArray.split(",");
            int[] ypoints = new int[ysplit.length];
            int i2 = 0;
            while (i2 < ysplit.length) {
                ypoints[i2] = Integer.parseInt(ysplit[i2].trim());
                ++i2;
            }
            this.polygon = new Polygon(xpoints, ypoints, xpoints.length);
        }
        return this.polygon;
    }

    public int getXStart(int y) {
        if (this.alignmentHorizontal.equals((Object)ALIGNMENT.LEFT)) {
            int i = 0;
            while (i < CustomCardMaker.cardWidth) {
                if (this.getPolygon().contains(i, y)) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public int getYStart(int x) {
        if (this.alignmentVertical.equals((Object)ALIGNMENT.TOP)) {
            int i = 0;
            while (i < CustomCardMaker.cardHeight) {
                if (this.getPolygon().contains(x, i)) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public Point getStartPosition() {
        if (this.alignmentHorizontal.equals((Object)ALIGNMENT.LEFT)) {
            int i = 0;
            while (i < CustomCardMaker.cardWidth) {
                int ypos = this.getYStart(i);
                if (ypos > -1) {
                    return new Point(i, ypos);
                }
                ++i;
            }
        }
        return null;
    }

    @Override
    public String generateOutputString() {
        return this.generateOutputString(false);
    }

    @Override
    public String generateOutputString(boolean fullExport) {
        String str = "";
        if (this.value != null) {
            str = String.valueOf(str) + "CUSTOMVALUE;" + this.name + ";value;" + this.value + "\n";
        }
        str = String.valueOf(str) + "CUSTOMVALUE;" + this.name + ";textSize;" + this.textSize + "\n";
        str = String.valueOf(str) + "CUSTOMVALUE;" + this.name + ";visible;" + this.visible + "\n";
        return str;
    }
}

